// External oscillator frequency
#define SYSCLK          32000000
#include "p24fj128ga008.h"

// Setup configuration bits
//_CONFIG1( JTAGEN_OFF & GCP_OFF & GWRP_OFF & COE_OFF & FWDTEN_OFF & ICS_PGx2) 
//_CONFIG2( FCKSM_CSDCMD & OSCIOFNC_ON & POSCMOD_HS & FNOSC_PRIPLL )


	_CONFIG2(FNOSC_PRIPLL & POSCMOD_XT)		// Primary XT OSC with 4x PLL
	_CONFIG1(JTAGEN_OFF & FWDTEN_OFF)		// JTAG off, watchdog timer off

#define   DELAY 16000
#define   BRATE   34        // 115200 Bd (BREGH=1)
#define   U_ENABLE 0x8008   // enable UART, BREGH=1, 1 stop, no parity
#define   U_TX 0x0400       // enable transmission, clear all fl ags

void initU1( void)
{

  // BREG2 = (Fosc / 8 / 115,200) -1 = 33.7 where Fosc = 32MHz.
	U1BRG = BRATE; // initialize the baud rate generator
	U1MODE = U_ENABLE; // initialize the UART module
	U1STA = U_TX; // enable the Transmitter

} // initU1

int putU1( int c)
{
	while ( U1STAbits.UTXBF); // wait while Tx buffer full
	U1TXREG = c;
return c;
} // putU1

char getU1( void)
{
	while ( !U1STAbits.URXDA); // wait for a new character to arrive
	return  U1RXREG;           // read the character from the receive buffer
}// getU1

//--------------------------------------------------------------------------------
int main ()
{   
   int i;
   char c;
   unsigned char text[]="HELLO";

	//Code goes here                                   								
    initU1();    // init the UART1 serial port

  for (i=0;i<sizeof(text);i++)   // Print HELLO
  {
      putU1(text[i]);
  }

    putU1( '>');        //  prompt

	while (1)
	{
		c = getU1();    // wait for a character
		putU1( c);      // echo the character

	} // End While
}  // End main
//--------------------------------------------------------------------------------